/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: DriverLayerMCHP.h                                                  *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/05/2007       1.0                              *
* Carlos Grossy              14/06/2007       1.1                              *
*******************************************************************************/

#ifndef _DRIVERLAYERMCHP_H_
#define _DRIVERLAYERMCHP_H_

#ifdef _DRIVER_MICROCHIP

using namespace std;
#include <map>
#include "DriverLayer.h"
#include "PlatformLayerWin32.h"
#include <windows.h>
#include "_mpusbapi.h"

typedef struct {
    int serial;
    int qtyep;
    dscEndpoint eps[15];
} itemBoard;

class driverLayerMCHP : public driverLayer {
    private:
        map<int,itemBoard> boards;
        int explenrecv;
        void findU4ABoards();
        void dscToMCHP(int, char *);
        int getInstance(int);
        platformLayerWin32 * pl;
    public:
        driverLayerMCHP();
        ~driverLayerMCHP();
        // Inicializacion
        int* getU4ABoards(int&);
        int qtyDsc(int);
        dscEndpoint* getEndpointDsc(int, int);
        // Utilizacion
        int open(int, int, usbin);
        int open(int, int, usbout);
        bool close(int);
        bool sendInt(int, char *, int, int);
        bool sendCtrl(int, char*, int, int);
        bool sendIso(int, char*, int, int);
        bool sendBulk(int, char*, int, int);
        char* receiveInt(int, int&, bool&, int);
        char* receiveCtrl(int, int&, bool&, int);
        char* receiveIso(int, int&, bool&, int);
        char* receiveBulk(int, int&, bool&, int);
};

#endif

#endif
